## This file reads in and saves HILDA longitudinal weights data in qs format 


# Preliminaries -----------------------------------------------------------

rm(list=ls())
gc()

memory.limit(size=25000)


# Master package loading
source("./R scripts/Master package loading.R", encoding="ISO-8859-1")


## hilda file paths
hilda_dta_path <- "./HILDA Wave 19/2. STATA 190/"
hilda_qs_path <- "./HILDA Wave 19/qs files/"


## get file locations of longitudinal weights file
long_weights_file <- list.files(hilda_dta_path) %>% 
  str_subset("longitudinal_weights_s190") %>% 
  str_remove(".dta")



# Read and save data ---------------------------------------------------------------


hilda_long_weights <- read_dta(paste0(hilda_dta_path, long_weights_file, ".dta")) 

## save
qsave(hilda_long_weights, paste0(hilda_qs_path, long_weights_file, ".qs"))

